 #include "hardware.h"

void SMC_setup(void)							// configure low-power run/stop modes
{
	SIM->CLKDIV1 = SIM_CLKDIV1_OUTDIV1(4);		// set 0.8 MHz bus clock 1:5 divider
	SMC->PMPROT = SMC_PMPROT_AVLP_MASK;						// allow VLPR, VLPW, VLPS modes
	SMC->PMCTRL = SMC_PMCTRL_RUNM(2) | SMC_PMCTRL_STOPM(2); // enter VLPS mode in STOP
	MCG->C1 |= MCG_C1_IRCLKEN_MASK;				// enable MCGIRCLK for timers	
}

void PORTS_setup(void)							// configure I/O ports
{
	SIM->SCGC5 |= SIM_SCGC5_PORTA_MASK | SIM_SCGC5_PORTB_MASK;		// enable clock for I/O ports
	PORTA->GPCLR = PORT_GPCLR_GPWE(0x1078) | PORT_GPCLR_GPWD(0x100);// set GPIO for PA[3:6], PA12	
	PORTA->GPCLR = PORT_GPCLR_GPWE(0x80) | PORT_GPCLR_GPWD(0x300);	// set SPI0 pin PA.7
	PTA->PDOR = 0x08;												// set CS_LCD high
	PTA->PDDR = 0x1078;												// output at PA[3:6], PA12
	PORTB->GPCLR = PORT_GPCLR_GPWE(0x06) | PORT_GPCLR_GPWD(0x100);	// set GPIO at PB[1:2]
	PORTB->GPCLR = PORT_GPCLR_GPWE(0xF8) | PORT_GPCLR_GPWD(0x103);	// pull-up at PB[3:7]
	PORTB->GPCLR = PORT_GPCLR_GPWE(0x01) | PORT_GPCLR_GPWD(0x300); 	// set SPI0 pit PB.0
	PTB->PDOR = 0;													
	PTB->PDDR = 0x06;												// configure PB[1:2] for output
}

void LPTMR0_setup(void)							// Low-Power Timer configuration
{												//    for 2 msec delay
	SIM->SCGC5 |= SIM_SCGC5_LPTMR_MASK;			// enable clock for LPTMR
	LPTMR0->CMR = 1;							// 2 msec delay
	LPTMR0->PSR = LPTMR_PSR_PBYP_MASK | LPTMR_PSR_PCS(1); // set LPO as clock source, no prescaler
	NVIC_ClearPendingIRQ(LPTimer_IRQn);			// clear pending LPTRM0 interrupt
	NVIC_EnableIRQ(LPTimer_IRQn);				// enable LPTMR0 interrupt in NVIC
	LPTMR0->CSR = LPTMR_CSR_TEN_MASK | LPTMR_CSR_TCF_MASK | LPTMR_CSR_TIE_MASK; // start timer
}	

void TPM1_setup(void)
{
	SIM->SCGC6 |= SIM_SCGC6_TPM1_MASK;				// enable clock to TMP1
	SIM->SOPT2 |= SIM_SOPT2_TPMSRC(3);				// select MCGIRCLK clock (4MHz)	
//	TPM1->SC = TPM_SC_PS(2) | TPM_SC_TOF_MASK | TPM_SC_TOIE_MASK; 	// use 1:4 prescaler
	NVIC_ClearPendingIRQ(TPM1_IRQn);				// enable TPM1 interrupt in NVIC
	NVIC_EnableIRQ(TPM1_IRQn);	
}

void SPI0_setup(void)
{
	SIM->SCGC4 |= SIM_SCGC4_SPI0_MASK;			// enable clock for SPI0 module
	SPI0->BR = 0;								// set bus_freq/2 baud rate	
	SPI0->C1 = SPI_C1_SPE_MASK | SPI_C1_MSTR_MASK;	
}
	
void SPI_send(uint8_t b)
{
	while (! (SPI0->S & SPI_S_SPTEF_MASK)){}	// wait for SPTE flag set
	SPI0->D = b;								// send the byte over
	while(! (SPI0->S & SPI_S_SPRF_MASK)){}
	b = SPI0->D;		
}
